/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import org.apache.log4j.Logger;

public class LoseAbilityAttachedEffect
extends ContinuousEffectImpl {
    private static final Logger logger = Logger.getLogger(LoseAbilityAttachedEffect.class);
    protected Ability ability;
    protected AttachmentType attachmentType;

    public LoseAbilityAttachedEffect(Ability ability, AttachmentType attachmentType) {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
        this.ability = ability;
        this.attachmentType = attachmentType;
        this.setText();
    }

    protected LoseAbilityAttachedEffect(LoseAbilityAttachedEffect effect) {
        super(effect);
        this.ability = effect.ability.copy();
        this.attachmentType = effect.attachmentType;
    }

    @Override
    public LoseAbilityAttachedEffect copy() {
        return new LoseAbilityAttachedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (creature = game.getPermanent(equipment.getAttachedTo())) != null) {
            creature.removeAbility(this.ability, source.getSourceId(), game);
        }
        return true;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attachmentType.verb());
        sb.append(" creature ");
        sb.append("loses ");
        sb.append(this.ability.getRule());
        this.staticText = sb.toString();
    }
}

