/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class LoseAllAbilitiesAllEffect
extends ContinuousEffectImpl {
    private final FilterPermanent filter;

    public LoseAllAbilitiesAllEffect(FilterPermanent filter, Duration duration) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
        this.filter = filter;
    }

    protected LoseAllAbilitiesAllEffect(LoseAllAbilitiesAllEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    @Override
    public LoseAllAbilitiesAllEffect copy() {
        return new LoseAllAbilitiesAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            if (permanent == null) continue;
            permanent.removeAllAbilities(source.getSourceId(), game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.duration == Duration.EndOfTurn) {
            sb.append(this.duration.toString()).append(", ");
        }
        sb.append(this.filter.getMessage()).append(" lose all abilities.");
        return sb.toString();
    }
}

