/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class MaximumHandSizeControllerEffect
extends ContinuousEffectImpl {
    protected DynamicValue handSize;
    protected HandSizeModification handSizeModification;
    protected TargetController targetController;

    public MaximumHandSizeControllerEffect(int handSize, Duration duration, HandSizeModification handSizeModification) {
        this(handSize, duration, handSizeModification, TargetController.YOU);
    }

    public MaximumHandSizeControllerEffect(int handSize, Duration duration, HandSizeModification handSizeModification, TargetController targetController) {
        this(StaticValue.get(handSize), duration, handSizeModification, targetController);
    }

    public MaximumHandSizeControllerEffect(DynamicValue handSize, Duration duration, HandSizeModification handSizeModification, TargetController targetController) {
        super(duration, Layer.PlayerEffects, SubLayer.NA, MaximumHandSizeControllerEffect.defineOutcome(handSizeModification, targetController));
        this.handSize = handSize;
        this.handSizeModification = handSizeModification;
        this.targetController = targetController;
        this.setText();
    }

    protected MaximumHandSizeControllerEffect(MaximumHandSizeControllerEffect effect) {
        super(effect);
        this.handSize = effect.handSize;
        this.handSizeModification = effect.handSizeModification;
        this.targetController = effect.targetController;
    }

    @Override
    public MaximumHandSizeControllerEffect copy() {
        return new MaximumHandSizeControllerEffect(this);
    }

    protected static Outcome defineOutcome(HandSizeModification handSizeModification, TargetController targetController) {
        Outcome newOutcome = Outcome.Benefit;
        if ((targetController == TargetController.YOU || targetController == TargetController.ANY) && handSizeModification == HandSizeModification.REDUCE) {
            newOutcome = Outcome.Detriment;
        }
        return newOutcome;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            switch (this.targetController) {
                case ANY: {
                    for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                        this.setHandSize(game, source, playerId);
                    }
                    break;
                }
                case OPPONENT: {
                    for (UUID playerId : game.getOpponents(source.getControllerId())) {
                        this.setHandSize(game, source, playerId);
                    }
                    break;
                }
                case YOU: {
                    this.setHandSize(game, source, source.getControllerId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
            return true;
        }
        return false;
    }

    private void setHandSize(Game game, Ability source, UUID playerId) {
        Player player = game.getPlayer(playerId);
        if (player != null) {
            switch (this.handSizeModification) {
                case SET: {
                    player.setMaxHandSize(this.handSize.calculate(game, source, this));
                    break;
                }
                case INCREASE: {
                    player.setMaxHandSize(player.getMaxHandSize() + this.handSize.calculate(game, source, this));
                    break;
                }
                case REDUCE: {
                    player.setMaxHandSize(player.getMaxHandSize() - this.handSize.calculate(game, source, this));
                }
            }
        }
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        if (this.handSize instanceof StaticValue && ((StaticValue)this.handSize).getValue() == Integer.MAX_VALUE) {
            switch (this.targetController) {
                case ANY: {
                    sb.append("Players have no maximum hand size");
                    break;
                }
                case OPPONENT: {
                    sb.append("Each opponent has no maximum hand size");
                    break;
                }
                case YOU: {
                    sb.append("You have no maximum hand size");
                }
            }
        } else {
            switch (this.targetController) {
                case ANY: {
                    sb.append("All players maximum hand size");
                    break;
                }
                case OPPONENT: {
                    sb.append("Each opponent's maximum hand size");
                    break;
                }
                case YOU: {
                    sb.append("Your maximum hand size");
                }
            }
            switch (this.handSizeModification) {
                case SET: {
                    sb.append(" is ");
                    break;
                }
                case INCREASE: {
                    sb.append(" is increased by ");
                    break;
                }
                case REDUCE: {
                    sb.append(" is reduced by ");
                }
            }
            if (this.handSize instanceof StaticValue) {
                sb.append(CardUtil.numberToText(((StaticValue)this.handSize).getValue()));
            } else if (!(this.handSize instanceof StaticValue)) {
                sb.append(this.handSize.getMessage());
            }
        }
        if (this.duration == Duration.EndOfGame) {
            sb.append(" for the rest of the game");
        }
        this.staticText = sb.toString();
    }

    public static enum HandSizeModification {
        SET,
        INCREASE,
        REDUCE;

    }
}

