/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

public class YouDontLoseManaEffect
extends ContinuousEffectImpl {
    private final ManaType manaType;

    public YouDontLoseManaEffect(ManaType manaType) {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.Detriment);
        this.staticText = "you don't lose unspent " + (Object)((Object)manaType) + " mana as steps and phases end";
        this.manaType = manaType;
    }

    private YouDontLoseManaEffect(YouDontLoseManaEffect effect) {
        super(effect);
        this.manaType = effect.manaType;
    }

    @Override
    public YouDontLoseManaEffect copy() {
        return new YouDontLoseManaEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.getManaPool().addDoNotEmptyManaType(this.manaType);
        }
        return false;
    }
}

