/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.cost;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class SpellsCostModificationThatTargetSourceEffect
extends CostModificationEffectImpl {
    private final FilterCard spellFilter;
    private final int modificationAmount;
    private String targetName = "{this}";
    private final TargetController targetController;

    public SpellsCostModificationThatTargetSourceEffect(int modificationAmount, FilterCard spellFilter, TargetController targetController) {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, modificationAmount < 0 ? CostModificationType.REDUCE_COST : CostModificationType.INCREASE_COST);
        this.spellFilter = spellFilter;
        this.modificationAmount = modificationAmount;
        this.targetController = targetController;
        this.setText();
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.spellFilter.getMessage());
        switch (this.targetController) {
            case ANY: {
                break;
            }
            case YOU: {
                sb.append(" you cast");
                break;
            }
            case OPPONENT: {
                sb.append(" your opponents cast");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported target controller " + (Object)((Object)this.targetController));
            }
        }
        sb.append(" that target ").append(this.targetName);
        if (this.modificationAmount < 0) {
            sb.append(" cost {").append(-1 * this.modificationAmount).append("} less to cast");
        } else {
            sb.append(" cost {").append(this.modificationAmount).append("} more to cast");
        }
        this.staticText = sb.toString();
    }

    private SpellsCostModificationThatTargetSourceEffect(SpellsCostModificationThatTargetSourceEffect effect) {
        super(effect);
        this.spellFilter = effect.spellFilter;
        this.modificationAmount = effect.modificationAmount;
        this.targetName = effect.targetName;
        this.targetController = effect.targetController;
    }

    @Override
    public SpellsCostModificationThatTargetSourceEffect copy() {
        return new SpellsCostModificationThatTargetSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        if (this.modificationAmount >= 0) {
            CardUtil.increaseCost(abilityToModify, this.modificationAmount);
        } else {
            CardUtil.reduceCost(abilityToModify, -1 * this.modificationAmount);
        }
        return true;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        Player sourceController = game.getPlayer(source.getControllerId());
        Player abilityController = game.getPlayer(abilityToModify.getControllerId());
        if (sourceController == null || abilityController == null) {
            return false;
        }
        switch (this.targetController) {
            case ANY: {
                break;
            }
            case YOU: {
                if (sourceController.getId().equals(abilityController.getId())) break;
                return false;
            }
            case OPPONENT: {
                if (sourceController.hasOpponent(abilityController.getId(), game)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
        if (!this.spellFilter.match(spellCard, game)) {
            return false;
        }
        if (game.getStack().getStackObject(abilityToModify.getId()) != null) {
            Set<UUID> allTargets = CardUtil.getAllSelectedTargets(abilityToModify, game);
            return allTargets.contains(source.getSourceId());
        }
        Set<UUID> allTargets = CardUtil.getAllPossibleTargets(abilityToModify, game);
        switch (this.getModificationType()) {
            case REDUCE_COST: {
                return allTargets.contains(source.getSourceId());
            }
            case INCREASE_COST: {
                return allTargets.contains(source.getSourceId()) && allTargets.size() <= 1;
            }
        }
        return false;
    }

    public SpellsCostModificationThatTargetSourceEffect withTargetName(String targetName) {
        this.targetName = targetName;
        this.setText();
        return this;
    }
}

