/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class AddCountersPlayersEffect
extends OneShotEffect {
    private final Counter counter;
    private final DynamicValue amount;
    private final TargetController targetController;

    public AddCountersPlayersEffect(Counter counter, TargetController targetController) {
        this(counter, StaticValue.get(0), targetController);
    }

    public AddCountersPlayersEffect(Counter counter, DynamicValue amount, TargetController targetController) {
        super(Outcome.Benefit);
        this.counter = counter;
        this.amount = amount;
        this.targetController = targetController;
        this.staticText = this.makeText();
    }

    private AddCountersPlayersEffect(AddCountersPlayersEffect effect) {
        super(effect);
        this.counter = effect.counter;
        this.amount = effect.amount;
        this.targetController = effect.targetController;
    }

    @Override
    public AddCountersPlayersEffect copy() {
        return new AddCountersPlayersEffect(this);
    }

    private Collection<UUID> getPlayers(Game game, Ability source) {
        switch (this.targetController) {
            case OPPONENT: {
                return game.getOpponents(source.getControllerId());
            }
            case EACH_PLAYER: 
            case ANY: {
                return game.getState().getPlayersInRange(source.getControllerId(), game);
            }
            case YOU: {
                return Collections.singletonList(source.getControllerId());
            }
            case CONTROLLER_ATTACHED_TO: {
                ArrayList<UUID> list = new ArrayList<UUID>();
                Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(Permanent::getAttachedTo).map(game::getControllerId).ifPresent(list::add);
                return list;
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this.targetController) + " not supported");
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Counter newCounter = this.counter.copy();
        int calculated = this.amount.calculate(game, source, this);
        if (!(this.amount instanceof StaticValue) || calculated > 0) {
            newCounter.remove(newCounter.getCount());
            newCounter.add(calculated);
        }
        if (newCounter.getCount() <= 0) {
            return false;
        }
        for (UUID playerId : this.getPlayers(game, source)) {
            Counter newCounterForPlayer = newCounter.copy();
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.addCounters(newCounterForPlayer, source.getControllerId(), source, game);
            game.informPlayers(player.getLogName() + " gets " + newCounterForPlayer.getCount() + ' ' + newCounterForPlayer.getName() + " counters" + CardUtil.getSourceLogName(game, source));
        }
        return true;
    }

    public String makeText() {
        StringBuilder sb = new StringBuilder();
        switch (this.targetController) {
            case OPPONENT: {
                sb.append("each opponent gets ");
                break;
            }
            case EACH_PLAYER: 
            case ANY: {
                sb.append("each player gets ");
                break;
            }
            case YOU: {
                sb.append("you get ");
                break;
            }
            case CONTROLLER_ATTACHED_TO: {
                sb.append("its controller gets ");
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.targetController) + " not supported");
            }
        }
        if (this.amount.toString().equals("X")) {
            sb.append("X ").append(this.counter.getName()).append(" counters");
        } else {
            sb.append(this.counter.getDescription());
        }
        return sb.toString();
    }
}

