/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.delayed.AtTheBeginOfNextCleanupDelayedTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.RemoveCountersAtEndOfTurn;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.util.CardUtil;

public class DistributeCountersEffect
extends OneShotEffect {
    private final CounterType counterType;
    private boolean removeAtEndOfTurn = false;

    public DistributeCountersEffect() {
        this(CounterType.P1P1);
    }

    public DistributeCountersEffect(CounterType counterType) {
        super(Outcome.BoostCreature);
        this.counterType = counterType;
    }

    protected DistributeCountersEffect(DistributeCountersEffect effect) {
        super(effect);
        this.counterType = effect.counterType;
        this.removeAtEndOfTurn = effect.removeAtEndOfTurn;
    }

    @Override
    public DistributeCountersEffect copy() {
        return new DistributeCountersEffect(this);
    }

    public DistributeCountersEffect withRemoveAtEndOfTurn() {
        this.removeAtEndOfTurn = true;
        return this;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (!source.getTargets().isEmpty()) {
            Target multiTarget = (Target)source.getTargets().get(0);
            for (UUID target : multiTarget.getTargets()) {
                Permanent permanent = game.getPermanent(target);
                if (permanent == null) continue;
                permanent.addCounters(this.counterType.createInstance(multiTarget.getTargetAmount(target)), source.getControllerId(), source, game);
            }
            if (this.removeAtEndOfTurn) {
                AtTheBeginOfNextCleanupDelayedTriggeredAbility ability = new AtTheBeginOfNextCleanupDelayedTriggeredAbility(new RemoveCountersAtEndOfTurn(this.counterType));
                ability.getTargets().addAll(source.getTargets());
                game.addDelayedTriggeredAbility(ability, source);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        Target target = (Target)mode.getTargets().get(0);
        if (!(target instanceof TargetAmount)) {
            throw new IllegalStateException("Must use TargetAmount");
        }
        TargetAmount targetAmount = (TargetAmount)target;
        DynamicValue amount = targetAmount.getAmount();
        String name = this.counterType.getName();
        String number = amount instanceof StaticValue ? CardUtil.numberToText(((StaticValue)amount).getValue()) : amount.toString();
        String text = "distribute " + number + ' ' + name + " counters among " + targetAmount.getDescription();
        if (this.removeAtEndOfTurn) {
            text = text + ". For each " + name + " counter you put on a creature this way, remove a " + name + " counter from that creature at the beginning of the next cleanup step.";
        }
        return text;
    }
}

