/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class GetEnergyCountersControllerEffect
extends OneShotEffect {
    private final DynamicValue value;

    public GetEnergyCountersControllerEffect(int value) {
        this(StaticValue.get(value));
    }

    public GetEnergyCountersControllerEffect(DynamicValue value) {
        super(Outcome.Benefit);
        this.value = value;
        this.setText();
    }

    protected GetEnergyCountersControllerEffect(GetEnergyCountersControllerEffect effect) {
        super(effect);
        this.value = effect.value;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            return controller.addCounters(CounterType.ENERGY.createInstance(this.value.calculate(game, source, this)), source.getControllerId(), source, game);
        }
        return false;
    }

    private void setText() {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return;
        }
        if (this.value.toString().equals("that many")) {
            this.staticText = "you get that many {E} <i>(energy counters)</i>.";
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("you get ");
        int val = this.value instanceof StaticValue ? ((StaticValue)this.value).getValue() : 1;
        if (val < 6) {
            for (int i = 0; i < val; ++i) {
                sb.append("{E}");
            }
        } else {
            sb.append(CardUtil.numberToText(val));
            sb.append(" {E}");
        }
        sb.append(" <i>(");
        sb.append(CardUtil.getSimpleCountersText(val, "an", "energy"));
        sb.append(")</i>");
        if (this.value instanceof StaticValue) {
            sb.append('.');
        } else {
            sb.append(" for each ");
            sb.append(this.value.getMessage());
        }
        this.staticText = sb.toString();
    }

    @Override
    public GetEnergyCountersControllerEffect copy() {
        return new GetEnergyCountersControllerEffect(this);
    }
}

