/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class RemoveCounterTargetEffect
extends OneShotEffect {
    private final Counter counter;

    public RemoveCounterTargetEffect() {
        super(Outcome.UnboostCreature);
        this.counter = null;
    }

    public RemoveCounterTargetEffect(Counter counter) {
        super(Outcome.UnboostCreature);
        this.counter = counter;
    }

    public RemoveCounterTargetEffect(RemoveCounterTargetEffect effect) {
        super(effect);
        this.counter = effect.counter == null ? null : effect.counter.copy();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent p = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (p != null) {
            Counter toRemove;
            Counter counter = toRemove = this.counter == null ? this.selectCounterType(game, source, p) : this.counter;
            if (toRemove != null && p.getCounters(game).getCount(toRemove.getName()) >= toRemove.getCount()) {
                p.removeCounters(toRemove.getName(), toRemove.getCount(), source, game);
                if (!game.isSimulation()) {
                    game.informPlayers("Removed " + toRemove.getCount() + ' ' + toRemove.getName() + " counter from " + p.getName());
                }
            }
        } else {
            Card c = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (c != null && this.counter != null && c.getCounters(game).getCount(this.counter.getName()) >= this.counter.getCount()) {
                c.removeCounters(this.counter.getName(), this.counter.getCount(), source, game);
                if (!game.isSimulation()) {
                    game.informPlayers("Removed " + this.counter.getCount() + ' ' + this.counter.getName() + " counter from " + c.getName() + " (" + c.getCounters(game).getCount(this.counter.getName()) + " left)");
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Counter selectCounterType(Game game, Ability source, Permanent permanent) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || permanent.getCounters(game).isEmpty()) return null;
        String counterName = null;
        if (permanent.getCounters(game).size() > 1) {
            ChoiceImpl choice = new ChoiceImpl(true);
            LinkedHashSet<String> choices = new LinkedHashSet<String>();
            for (Counter counterOnPermanent : permanent.getCounters(game).values()) {
                if (permanent.getCounters(game).getCount(counterOnPermanent.getName()) <= 0) continue;
                choices.add(counterOnPermanent.getName());
            }
            choice.setChoices(choices);
            choice.setMessage("Choose a counter type to remove from " + permanent.getName());
            if (!controller.choose(Outcome.Detriment, choice, game)) return null;
            counterName = choice.getChoice();
            return new Counter(counterName);
        } else {
            for (Counter counterOnPermanent : permanent.getCounters(game).values()) {
                if (counterOnPermanent.getCount() <= 0) continue;
                counterName = counterOnPermanent.getName();
            }
        }
        return new Counter(counterName);
    }

    @Override
    public RemoveCounterTargetEffect copy() {
        return new RemoveCounterTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "remove " + (this.counter == null ? "a counter" : this.counter.getDescription()) + " from " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature");
    }
}

