/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.ruleModifying;

import java.util.Locale;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;

public class CastOnlyDuringPhaseStepSourceEffect
extends ContinuousRuleModifyingEffectImpl {
    private final TurnPhase turnPhase;
    private final PhaseStep phaseStep;
    private final Condition condition;

    public CastOnlyDuringPhaseStepSourceEffect(TurnPhase turnPhase, PhaseStep phaseStep, Condition condition) {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.turnPhase = turnPhase;
        this.phaseStep = phaseStep;
        this.condition = condition;
        this.staticText = this.setText();
    }

    private CastOnlyDuringPhaseStepSourceEffect(CastOnlyDuringPhaseStepSourceEffect effect) {
        super(effect);
        this.turnPhase = effect.turnPhase;
        this.phaseStep = effect.phaseStep;
        this.condition = effect.condition;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getSourceId().equals(source.getSourceId()) && (this.turnPhase != null && game.getTurnPhaseType() != this.turnPhase || this.phaseStep != null && game.getTurnStepType() != this.phaseStep || this.condition != null && !this.condition.apply(game, source));
    }

    @Override
    public CastOnlyDuringPhaseStepSourceEffect copy() {
        return new CastOnlyDuringPhaseStepSourceEffect(this);
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("cast this spell only during ");
        if (this.turnPhase != null) {
            sb.append(this.turnPhase.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.phaseStep != null) {
            sb.append("the ").append(this.phaseStep.getStepText());
        }
        if (this.condition != null) {
            sb.append(' ').append(this.condition.toString());
        }
        return sb.toString();
    }
}

