/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.ruleModifying;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

public class DontCauseTriggerEffect
extends ContinuousRuleModifyingEffectImpl {
    private final FilterPermanent filterEntering;
    private final boolean orDying;
    private final FilterPermanent filterTriggering;

    public DontCauseTriggerEffect() {
        this(StaticFilters.FILTER_PERMANENT_CREATURES, false, null);
    }

    public DontCauseTriggerEffect(FilterPermanent filterEntering, boolean orDying, FilterPermanent filterTriggering) {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.filterEntering = filterEntering;
        this.orDying = orDying;
        this.filterTriggering = filterTriggering;
        this.staticText = filterEntering.getMessage() + " entering" + (orDying ? " or dying" : "") + " don't cause abilities" + (filterTriggering == null ? "" : " of " + filterTriggering.getMessage()) + " to trigger";
    }

    protected DontCauseTriggerEffect(DontCauseTriggerEffect effect) {
        super(effect);
        this.filterEntering = effect.filterEntering;
        this.orDying = effect.orDying;
        this.filterTriggering = effect.filterTriggering;
    }

    @Override
    public DontCauseTriggerEffect copy() {
        return new DontCauseTriggerEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        GameEvent sourceEvent;
        if (this.filterTriggering != null) {
            Ability ability = (Ability)this.getValue("targetAbility");
            if (ability == null) {
                return false;
            }
            Permanent triggeringPermanent = ability.getSourcePermanentOrLKI(game);
            if (triggeringPermanent == null || !this.filterTriggering.match(triggeringPermanent, source.getControllerId(), source, game)) {
                return false;
            }
        }
        if ((sourceEvent = ((NumberOfTriggersEvent)event).getSourceEvent()) == null) {
            return false;
        }
        switch (sourceEvent.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                Permanent enteringPermanent = ((EntersTheBattlefieldEvent)sourceEvent).getTarget();
                if (enteringPermanent != null && this.filterEntering.match(enteringPermanent, source.getControllerId(), source, game)) break;
                return false;
            }
            case ZONE_CHANGE: {
                Permanent dyingPermanent;
                if (this.orDying && ((ZoneChangeEvent)sourceEvent).isDiesEvent() && (dyingPermanent = ((ZoneChangeEvent)sourceEvent).getTarget()) != null && this.filterEntering.match(dyingPermanent, source.getControllerId(), source, game)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Ability ability = (Ability)this.getValue("targetAbility");
        if (ability == null) {
            return null;
        }
        MageObject abilityObject = game.getObject(ability.getSourceId());
        if (abilityObject == null) {
            return null;
        }
        return "Prevented ability of " + abilityObject.getLogName() + " from triggering.";
    }
}

