/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.SearchEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

public class SearchLibraryAndExileTargetEffect
extends SearchEffect {
    public SearchLibraryAndExileTargetEffect(int amount, boolean upTo) {
        super(new TargetCardInLibrary(upTo ? 0 : amount, amount, amount > 1 ? StaticFilters.FILTER_CARD_CARDS : StaticFilters.FILTER_CARD), Outcome.Exile);
    }

    private SearchLibraryAndExileTargetEffect(SearchLibraryAndExileTargetEffect effect) {
        super(effect);
    }

    @Override
    public SearchLibraryAndExileTargetEffect copy() {
        return new SearchLibraryAndExileTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        controller.searchLibrary(this.target, source, game, player.getId());
        CardsImpl cards = new CardsImpl();
        this.target.getTargets().stream().map(uuid -> player.getLibrary().getCard((UUID)uuid, game)).forEach(cards::add);
        controller.moveCards(cards, Zone.EXILED, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "search " + this.getTargetPointer().describeTargets(mode.getTargets(), "that player") + "'s library for " + this.target.getDescription() + (this.target.getMaxNumberOfTargets() > 1 ? " and exile them" : " and exile it") + ". Then that player shuffles";
    }
}

