/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

public class SearchLibraryGraveyardWithLessMVPutIntoPlay
extends OneShotEffect {
    private final FilterCard filter;

    public SearchLibraryGraveyardWithLessMVPutIntoPlay() {
        this(new FilterCard());
    }

    public SearchLibraryGraveyardWithLessMVPutIntoPlay(FilterCard filter) {
        super(Outcome.PutCreatureInPlay);
        this.filter = filter;
        this.staticText = "Search your library and/or graveyard for a " + filter.getMessage() + " with mana value X or less and put it onto the battlefield. If you search your library this way, shuffle.";
    }

    protected SearchLibraryGraveyardWithLessMVPutIntoPlay(SearchLibraryGraveyardWithLessMVPutIntoPlay effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public SearchLibraryGraveyardWithLessMVPutIntoPlay copy() {
        return new SearchLibraryGraveyardWithLessMVPutIntoPlay(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        Card cardFound = null;
        if (controller != null && sourceObject != null) {
            TargetCard target;
            FilterCard advancedFilter = this.filter.copy();
            advancedFilter.add(new ManaValuePredicate(ComparisonType.FEWER_THAN, CardUtil.getSourceCostsTag(game, source, "X", 0) + 1));
            if (controller.chooseUse(this.outcome, "Search your library for a " + this.filter.getMessage() + " with mana value X or less" + '?', source, game)) {
                target = new TargetCardInLibrary(advancedFilter);
                target.clearChosen();
                if (controller.searchLibrary((TargetCardInLibrary)target, source, game) && !target.getTargets().isEmpty()) {
                    cardFound = game.getCard(target.getFirstTarget());
                }
                controller.shuffleLibrary(source, game);
            }
            if (cardFound == null && controller.chooseUse(this.outcome, "Search your graveyard for a " + this.filter.getMessage() + " with mana value X or less" + '?', source, game)) {
                target = new TargetCard(0, 1, Zone.GRAVEYARD, advancedFilter);
                target.clearChosen();
                if (controller.choose(this.outcome, controller.getGraveyard(), target, source, game) && !target.getTargets().isEmpty()) {
                    cardFound = game.getCard(target.getFirstTarget());
                }
            }
            if (cardFound != null) {
                controller.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(cardFound), game);
                controller.moveCards(cardFound, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

