/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

public class SearchLibraryWithLessCMCPutInPlayEffect
extends OneShotEffect {
    private final FilterCard filter;

    public SearchLibraryWithLessCMCPutInPlayEffect() {
        this(new FilterCard());
    }

    public SearchLibraryWithLessCMCPutInPlayEffect(FilterCard filter) {
        super(Outcome.PutCreatureInPlay);
        this.filter = filter;
        this.staticText = "Search your library for " + CardUtil.addArticle(filter.getMessage()) + " with mana value X or less, put it onto the battlefield, then shuffle";
    }

    protected SearchLibraryWithLessCMCPutInPlayEffect(SearchLibraryWithLessCMCPutInPlayEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FilterCard advancedFilter = this.filter.copy();
            advancedFilter.add(new ManaValuePredicate(ComparisonType.FEWER_THAN, CardUtil.getSourceCostsTag(game, source, "X", 0) + 1));
            TargetCardInLibrary target = new TargetCardInLibrary(advancedFilter);
            if (controller.searchLibrary(target, source, game)) {
                Card card;
                if (!target.getTargets().isEmpty() && (card = controller.getLibrary().getCard(target.getFirstTarget(), game)) != null) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
                controller.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }

    @Override
    public SearchLibraryWithLessCMCPutInPlayEffect copy() {
        return new SearchLibraryWithLessCMCPutInPlayEffect(this);
    }
}

