/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class EarthbendingDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference mor;

    EarthbendingDelayedTriggeredAbility(Permanent permanent, Game game) {
        super(new ReturnToBattlefieldUnderOwnerControlTargetEffect(true, false), Duration.Custom, true, false);
        this.mor = new MageObjectReference(permanent, game, 1);
        this.getAllEffects().setTargetPointer(new FixedTarget(this.mor));
    }

    private EarthbendingDelayedTriggeredAbility(EarthbendingDelayedTriggeredAbility ability) {
        super(ability);
        this.mor = ability.mor;
    }

    @Override
    public EarthbendingDelayedTriggeredAbility copy() {
        return new EarthbendingDelayedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getFromZone() == Zone.BATTLEFIELD && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.EXILED) && this.mor.refersTo(zEvent.getTarget(), game, -1);
    }

    @Override
    public String getRule() {
        return "When it dies or is exiled, return it to the battlefield tapped.";
    }
}

