/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import java.util.Locale;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class EchoEffect
extends OneShotEffect {
    protected Cost cost;
    protected DynamicValue amount;

    public EchoEffect(Cost costs) {
        super(Outcome.Sacrifice);
        this.cost = costs;
        this.amount = null;
    }

    public EchoEffect(DynamicValue amount) {
        super(Outcome.Sacrifice);
        this.amount = amount;
        this.cost = null;
    }

    protected EchoEffect(EchoEffect effect) {
        super(effect);
        this.cost = effect.cost == null ? null : effect.cost.copy();
        this.amount = effect.amount;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller;
        if (this.cost == null) {
            this.cost = new GenericManaCost(this.amount.calculate(game, source, this));
        }
        if ((controller = game.getPlayer(source.getControllerId())) != null && source.getSourceObjectIfItStillExists(game) != null) {
            Permanent permanent;
            if (!game.getContinuousEffects().asThough(source.getSourceId(), AsThoughEffectType.PAY_0_ECHO, source, source.getControllerId(), game).isEmpty()) {
                GenericManaCost altCost = new GenericManaCost(0);
                if (controller.chooseUse(Outcome.Benefit, "Pay {0} instead of the echo cost?", source, game)) {
                    altCost.clearPaid();
                    if (altCost.pay(source, game, source, source.getControllerId(), false, null)) {
                        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.ECHO_PAID, source.getSourceId(), source, source.getControllerId()));
                        return true;
                    }
                }
            }
            if (controller.chooseUse(Outcome.Benefit, "Pay " + this.cost.getText() + '?', source, game)) {
                this.cost.clearPaid();
                if (this.cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    game.fireEvent(GameEvent.getEvent(GameEvent.EventType.ECHO_PAID, source.getSourceId(), source, source.getControllerId()));
                    return true;
                }
            }
            if ((permanent = game.getPermanent(source.getSourceId())) != null) {
                permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }

    @Override
    public EchoEffect copy() {
        return new EchoEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("sacrifice {this} unless you ");
        if (this.cost == null) {
            sb.append("pay this permanent's mana cost");
            return sb.toString();
        }
        String costText = this.cost.getText();
        if (costText.toLowerCase(Locale.ENGLISH).startsWith("discard")) {
            sb.append(costText.substring(0, 1).toLowerCase(Locale.ENGLISH));
            sb.append(costText.substring(1));
        } else {
            sb.append("pay ").append(costText);
        }
        return sb.toString();
    }
}

