/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class ManifestTargetPlayerEffect
extends OneShotEffect {
    private final int amount;
    private final String prefix;

    public ManifestTargetPlayerEffect(int amount, String prefix) {
        super(Outcome.PutCreatureInPlay);
        this.amount = amount;
        this.prefix = prefix;
        this.staticText = this.setText();
    }

    protected ManifestTargetPlayerEffect(ManifestTargetPlayerEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.prefix = effect.prefix;
    }

    @Override
    public ManifestTargetPlayerEffect copy() {
        return new ManifestTargetPlayerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        return !ManifestEffect.doManifestCards(game, source, targetPlayer, targetPlayer.getLibrary().getTopCards(game, this.amount)).isEmpty();
    }

    private String setText() {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null && !this.prefix.isEmpty()) {
            sb.append(this.prefix).append(' ');
        }
        sb.append("manifest the top ");
        if (this.amount > 1) {
            sb.append(CardUtil.numberToText(this.amount)).append(" cards ");
        } else {
            sb.append("card ");
        }
        sb.append("of their library. ");
        if (this.amount > 1) {
            sb.append("<i>(To manifest a card, put it onto the battlefield face down as a 2/2 creature. The controller may turn it face up at any time for its mana cost if it's a creature card.)</i>");
        } else {
            sb.append("<i>(That player puts the top card of their library onto the battlefield face down as a 2/2 creature. If it's a creature card, it can be turned face up any time for its mana cost.)</i>");
        }
        return sb.toString();
    }
}

