/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class SurveilEffect
extends OneShotEffect {
    protected final int surveilNumber;
    protected final boolean showEffectHint;

    public SurveilEffect(int surveilNumber) {
        this(surveilNumber, true);
    }

    public SurveilEffect(int surveilNumber, boolean showEffectHint) {
        super(Outcome.Benefit);
        this.surveilNumber = surveilNumber;
        this.showEffectHint = showEffectHint;
        this.setText();
    }

    protected SurveilEffect(SurveilEffect effect) {
        super(effect);
        this.surveilNumber = effect.surveilNumber;
        this.showEffectHint = effect.showEffectHint;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            return player.surveil(this.surveilNumber, source, game);
        }
        return false;
    }

    @Override
    public SurveilEffect copy() {
        return new SurveilEffect(this);
    }

    private void setText() {
        StringBuilder sb = new StringBuilder("surveil ").append(this.surveilNumber);
        if (!this.showEffectHint) {
            this.staticText = sb.toString();
            return;
        }
        if (this.surveilNumber == 1) {
            sb.append(". <i>(Look at the top card of your library. You may put that card into your graveyard.)</i>");
        } else {
            sb.append(". <i>(Look at the top ");
            sb.append(CardUtil.numberToText(this.surveilNumber));
            sb.append(" cards of your library, then put any number of them into your graveyard and the rest on top in any order.)</i>");
        }
        this.staticText = sb.toString();
    }
}

