/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.constants.ManaType;
import mage.game.Game;
import mage.util.CardUtil;

public class AddConditionalManaEffect
extends ManaEffect {
    private final Mana mana;
    private final ConditionalManaBuilder manaBuilder;
    private final DynamicValue netAmount;

    public AddConditionalManaEffect(Mana mana, ConditionalManaBuilder manaBuilder) {
        this(mana, manaBuilder, null);
    }

    public AddConditionalManaEffect(Mana mana, ConditionalManaBuilder manaBuilder, DynamicValue netAmount) {
        this.mana = mana;
        this.manaBuilder = manaBuilder;
        this.netAmount = netAmount;
        this.staticText = "Add " + this.mana.toString() + ". " + manaBuilder.getRule();
    }

    protected AddConditionalManaEffect(AddConditionalManaEffect effect) {
        super(effect);
        this.mana = effect.mana.copy();
        this.manaBuilder = effect.manaBuilder;
        this.netAmount = effect.netAmount;
    }

    @Override
    public AddConditionalManaEffect copy() {
        return new AddConditionalManaEffect(this);
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        if (game != null && game.inCheckPlayableState() && this.netAmount != null) {
            ArrayList<Mana> maxAvailableMana = new ArrayList<Mana>();
            int amountAvailableMana = this.netAmount.calculate(game, source, this);
            if (amountAvailableMana > 0) {
                Mana calculatedMana = this.mana.copy();
                for (ManaType manaType : ManaType.getTrueManaTypes()) {
                    calculatedMana.set(manaType, CardUtil.overflowMultiply(calculatedMana.get(manaType), amountAvailableMana));
                }
                maxAvailableMana.add((Mana)this.manaBuilder.setMana(calculatedMana, source, game).build(new Object[0]));
            }
            return maxAvailableMana;
        }
        return super.getNetMana(game, source);
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        if (game != null) {
            return (Mana)this.manaBuilder.setMana(this.mana, source, game).build(new Object[0]);
        }
        return new Mana();
    }

    public Mana getMana() {
        return this.mana;
    }
}

