/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.mana.ManaEffect;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;

public class AddManaChosenColorEffect
extends ManaEffect {
    private ObjectColor chosenColorInfo = null;

    public AddManaChosenColorEffect() {
        this.staticText = "Add one mana of the chosen color";
    }

    protected AddManaChosenColorEffect(AddManaChosenColorEffect effect) {
        super(effect);
        this.chosenColorInfo = effect.chosenColorInfo;
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        ObjectColor color;
        if (game != null && (color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color")) != null) {
            this.chosenColorInfo = color;
            return new Mana(ColoredManaSymbol.lookup(color.toString().charAt(0)));
        }
        return new Mana();
    }

    @Override
    public AddManaChosenColorEffect copy() {
        return new AddManaChosenColorEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        return super.getText(mode) + (this.chosenColorInfo == null ? "" : " {" + this.chosenColorInfo.toString() + "}");
    }
}

