/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.choices.ChoiceColor;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class AddManaOfAnyColorEffect
extends BasicManaEffect {
    protected final int amount;
    protected final DynamicValue netAmount;
    protected final ArrayList<Mana> netMana = new ArrayList();
    protected final boolean setFlag;

    public AddManaOfAnyColorEffect() {
        this(1);
    }

    public AddManaOfAnyColorEffect(int amount) {
        this(amount, false);
    }

    public AddManaOfAnyColorEffect(int amount, boolean setFlag) {
        this(amount, null, setFlag);
    }

    public AddManaOfAnyColorEffect(int amount, DynamicValue netAmount, boolean setFlag) {
        super(new Mana(0, 0, 0, 0, 0, 0, amount, 0));
        this.amount = amount;
        this.netAmount = netAmount;
        this.netMana.add(Mana.AnyMana(amount));
        this.staticText = "add " + CardUtil.numberToText(amount) + " mana of any " + (amount > 1 ? "one " : "") + "color";
        this.setFlag = setFlag;
    }

    protected AddManaOfAnyColorEffect(AddManaOfAnyColorEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.netMana.addAll(effect.netMana);
        this.setFlag = effect.setFlag;
        this.netAmount = effect.netAmount == null ? null : effect.netAmount.copy();
    }

    @Override
    public AddManaOfAnyColorEffect copy() {
        return new AddManaOfAnyColorEffect(this);
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        if (game != null && game.inCheckPlayableState() && this.netAmount != null) {
            int count = this.netAmount.calculate(game, source, this);
            Mana mana = new Mana();
            mana.setAny(count * this.amount);
            ArrayList<Mana> possibleNetMana = new ArrayList<Mana>();
            possibleNetMana.add(mana);
            return possibleNetMana;
        }
        return new ArrayList<Mana>(this.netMana);
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        ChoiceColor choice;
        String mes;
        Player controller;
        if (game != null && (controller = game.getPlayer(source.getControllerId())) != null && (mes = String.format("Select a color of mana to add %d of it", this.amount)) != null && controller.choose(this.outcome, choice = new ChoiceColor(true, mes, game.getObject(source)), game) && choice.getColor() != null) {
            Mana mana = choice.getMana(this.amount);
            mana.setFlag(this.setFlag);
            return mana;
        }
        return new Mana();
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public Mana getManaTemplate() {
        return Mana.AnyMana(this.amount);
    }
}

