/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.ConditionalMana;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.mana.ManaEffect;
import mage.game.Game;

public class BasicManaEffect
extends ManaEffect {
    private final Mana manaTemplate;
    private final DynamicValue netAmount;

    public BasicManaEffect(Mana mana) {
        this(mana, null);
    }

    public BasicManaEffect(Mana mana, DynamicValue netAmount) {
        this.manaTemplate = mana;
        this.staticText = "add " + mana.toString();
        this.netAmount = netAmount;
    }

    public BasicManaEffect(ConditionalMana conditionalMana) {
        this(conditionalMana, null);
    }

    public BasicManaEffect(ConditionalMana conditionalMana, DynamicValue netAmount) {
        this.manaTemplate = conditionalMana;
        this.staticText = "add " + this.manaTemplate.toString() + " " + conditionalMana.getDescription();
        this.netAmount = netAmount;
    }

    protected BasicManaEffect(BasicManaEffect effect) {
        super(effect);
        this.manaTemplate = effect.manaTemplate;
        this.netAmount = effect.netAmount;
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        if (game != null && game.inCheckPlayableState() && this.netAmount != null) {
            int count = this.netAmount.calculate(game, source, this);
            Mana computedMana = this.manaTemplate.copy();
            if (count > 0) {
                if (this.manaTemplate.getBlack() > 0) {
                    computedMana.setBlack(count * this.manaTemplate.getBlack());
                }
                if (this.manaTemplate.getBlue() > 0) {
                    computedMana.setBlue(count * this.manaTemplate.getBlue());
                }
                if (this.manaTemplate.getGreen() > 0) {
                    computedMana.setGreen(count * this.manaTemplate.getGreen());
                }
                if (this.manaTemplate.getRed() > 0) {
                    computedMana.setRed(count * this.manaTemplate.getRed());
                }
                if (this.manaTemplate.getWhite() > 0) {
                    computedMana.setWhite(count * this.manaTemplate.getWhite());
                }
                if (this.manaTemplate.getColorless() > 0) {
                    computedMana.setColorless(count * this.manaTemplate.getColorless());
                }
                if (this.manaTemplate.getAny() > 0) {
                    throw new IllegalArgumentException("BasicManaEffect does not support {Any} mana!");
                }
                if (this.manaTemplate.getGeneric() > 0) {
                    computedMana.setGeneric(count * this.manaTemplate.getGeneric());
                }
            }
            return new ArrayList<Mana>(Arrays.asList(computedMana));
        }
        return super.getNetMana(game, source);
    }

    @Override
    public BasicManaEffect copy() {
        return new BasicManaEffect(this);
    }

    public Mana getManaTemplate() {
        return this.manaTemplate.copy();
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        return this.manaTemplate.copy();
    }
}

