/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.effects.mana.ManaEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class DoUnlessAnyPlayerPaysManaEffect
extends ManaEffect {
    private final ManaEffect manaEffect;
    private final Cost cost;
    private final String chooseUseText;

    public DoUnlessAnyPlayerPaysManaEffect(ManaEffect effect, Cost cost, String chooseUseText) {
        this.manaEffect = effect;
        this.cost = cost;
        this.chooseUseText = chooseUseText;
    }

    protected DoUnlessAnyPlayerPaysManaEffect(DoUnlessAnyPlayerPaysManaEffect effect) {
        super(effect);
        this.manaEffect = (ManaEffect)effect.manaEffect.copy();
        this.cost = effect.cost.copy();
        this.chooseUseText = effect.chooseUseText;
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        return this.manaEffect.getNetMana(game, source);
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game != null) {
            Player controller = this.getPlayer(game, source);
            MageObject sourceObject = game.getObject(source);
            String message = CardUtil.replaceSourceName(this.chooseUseText, sourceObject.getName());
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.canRespond() || !this.cost.canPay(source, source, player.getId(), game) || !player.chooseUse(Outcome.Detriment, message, source, game)) continue;
                this.cost.clearPaid();
                if (!this.cost.pay(source, game, source, player.getId(), false, null)) continue;
                if (!game.isSimulation()) {
                    game.informPlayers(player.getLogName() + " pays the cost to prevent the effect");
                }
                return mana;
            }
        }
        return this.manaEffect.produceMana(game, source);
    }

    @Override
    public String getText(Mode mode) {
        if (!this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.manaEffect.getText(mode) + " unless any player pays " + this.cost.getText();
    }

    @Override
    public DoUnlessAnyPlayerPaysManaEffect copy() {
        return new DoUnlessAnyPlayerPaysManaEffect(this);
    }
}

