/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.ChoiceColor;
import mage.constants.ManaType;
import mage.constants.MultiAmountType;
import mage.game.Game;
import mage.players.Player;

public class DynamicManaEffect
extends ManaEffect {
    private Mana baseMana;
    private final DynamicValue amount;
    private final DynamicValue netAmount;
    private String text;
    private boolean oneChoice;

    public DynamicManaEffect(Mana mana, DynamicValue amount) {
        this(mana, amount, null);
    }

    public DynamicManaEffect(Mana mana, DynamicValue amount, String text) {
        this(mana, amount, text, false);
    }

    public DynamicManaEffect(Mana mana, DynamicValue amount, String text, boolean oneChoice) {
        this(mana, amount, text, oneChoice, null);
    }

    public DynamicManaEffect(Mana mana, DynamicValue amount, String text, boolean oneChoice, DynamicValue netAmount) {
        this.baseMana = mana;
        this.amount = amount;
        this.text = text;
        this.oneChoice = oneChoice;
        this.netAmount = netAmount;
    }

    protected DynamicManaEffect(DynamicManaEffect effect) {
        super(effect);
        this.baseMana = effect.baseMana.copy();
        this.amount = effect.amount.copy();
        this.text = effect.text;
        this.oneChoice = effect.oneChoice;
        this.netAmount = effect.netAmount != null ? effect.netAmount.copy() : null;
    }

    @Override
    public DynamicManaEffect copy() {
        return new DynamicManaEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.text != null && !this.text.isEmpty()) {
            return this.text;
        }
        return "add " + this.baseMana.toString() + " for each " + this.amount.getMessage();
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        Mana computedMana = new Mana();
        int count = this.netAmount != null ? this.netAmount.calculate(game, source, this) : this.amount.calculate(game, source, this);
        if (this.baseMana.getBlack() > 0) {
            computedMana.setBlack(count);
        } else if (this.baseMana.getBlue() > 0) {
            computedMana.setBlue(count);
        } else if (this.baseMana.getGreen() > 0) {
            computedMana.setGreen(count);
        } else if (this.baseMana.getRed() > 0) {
            computedMana.setRed(count);
        } else if (this.baseMana.getWhite() > 0) {
            computedMana.setWhite(count);
        } else if (this.baseMana.getColorless() > 0) {
            computedMana.setColorless(count);
        } else if (this.baseMana.getAny() > 0) {
            computedMana.setAny(count);
        } else {
            computedMana.setGeneric(count);
        }
        netMana.add(computedMana);
        return netMana;
    }

    @Override
    public Set<ManaType> getProducableManaTypes(Game game, Ability source) {
        return ManaType.getManaTypesFromManaList(this.baseMana);
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        Mana computedMana = new Mana();
        if (game == null) {
            return computedMana;
        }
        int count = this.amount.calculate(game, source, this);
        if (this.baseMana.getBlack() > 0) {
            computedMana.setBlack(count);
        } else if (this.baseMana.getBlue() > 0) {
            computedMana.setBlue(count);
        } else if (this.baseMana.getGreen() > 0) {
            computedMana.setGreen(count);
        } else if (this.baseMana.getRed() > 0) {
            computedMana.setRed(count);
        } else if (this.baseMana.getWhite() > 0) {
            computedMana.setWhite(count);
        } else if (this.baseMana.getColorless() > 0) {
            computedMana.setColorless(count);
        } else if (this.baseMana.getAny() > 0) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null && count > 0) {
                if (this.oneChoice || count == 1) {
                    ChoiceColor choice = new ChoiceColor(true);
                    controller.choose(this.outcome, choice, game);
                    if (choice.getChoice() == null) {
                        return computedMana;
                    }
                    computedMana.add(choice.getMana(count));
                } else {
                    ArrayList<String> manaStrings = new ArrayList<String>(5);
                    manaStrings.add("W");
                    manaStrings.add("U");
                    manaStrings.add("B");
                    manaStrings.add("R");
                    manaStrings.add("G");
                    List<Integer> choices = controller.getMultiAmount(this.outcome, manaStrings, 0, count, count, MultiAmountType.MANA, game);
                    computedMana.add(new Mana(choices.get(0), choices.get(1), choices.get(2), choices.get(3), choices.get(4), 0, 0, 0));
                }
            }
        } else {
            computedMana.setGeneric(count);
        }
        return computedMana;
    }
}

