/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint;

import java.awt.Color;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.hint.Hint;
import mage.abilities.hint.HintUtils;
import mage.game.Game;
import mage.util.CardUtil;

public class ConditionTrueHint
implements Hint {
    private Condition condition;
    private String trueText;
    private Color trueColor;
    private Boolean useIcons;

    public ConditionTrueHint(Condition condition) {
        this(condition, condition.toString());
    }

    public ConditionTrueHint(Condition condition, String textWithIcons) {
        this(condition, textWithIcons, null, true);
    }

    public ConditionTrueHint(Condition condition, String trueText, Color trueColor, Boolean useIcons) {
        this.condition = condition;
        this.trueText = CardUtil.getTextWithFirstCharUpperCase(trueText);
        this.trueColor = trueColor;
        this.useIcons = useIcons;
    }

    protected ConditionTrueHint(ConditionTrueHint hint) {
        this.condition = hint.condition;
        this.trueText = hint.trueText;
        this.trueColor = hint.trueColor;
        this.useIcons = hint.useIcons;
    }

    @Override
    public String getText(Game game, Ability ability) {
        if (this.condition.apply(game, ability)) {
            String icon = this.useIcons != false ? "ICON_GOOD" : null;
            return HintUtils.prepareText(this.trueText, this.trueColor, icon);
        }
        return "";
    }

    @Override
    public ConditionTrueHint copy() {
        return new ConditionTrueHint(this);
    }
}

