/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ActivationManaAbilityStep;
import mage.abilities.costs.mana.AlternateManaPaymentAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.keyword.AssistSpecialAction;
import mage.abilities.mana.ManaOptions;
import mage.constants.AbilityType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPlayer;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetPlayer;

public class AssistAbility
extends SimpleStaticAbility
implements AlternateManaPaymentAbility {
    private static final FilterPlayer filter = new FilterPlayer("another player");

    public AssistAbility() {
        super(Zone.ALL, null);
        this.setRuleAtTheTop(true);
    }

    protected AssistAbility(AssistAbility ability) {
        super(ability);
    }

    @Override
    public AssistAbility copy() {
        return new AssistAbility(this);
    }

    @Override
    public String getRule() {
        return "Assist <i>(Another player can help pay the generic mana of this spell's cost.)</i>";
    }

    @Override
    public ActivationManaAbilityStep useOnActivationManaAbilityStep() {
        return ActivationManaAbilityStep.BEFORE;
    }

    @Override
    public void addSpecialAction(Ability source, Game game, ManaCost unpaid) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && source.getAbilityType() == AbilityType.SPELL && unpaid.getMana().getGeneric() >= 1 && game.getState().getValue(source.getSourceId().toString() + game.getState().getZoneChangeCounter(source.getSourceId()) + "_assisted") == null) {
            AssistSpecialAction specialAction = new AssistSpecialAction(unpaid, (AlternateManaPaymentAbility)this);
            specialAction.setControllerId(source.getControllerId());
            specialAction.setSourceId(source.getSourceId());
            TargetPlayer target = new TargetPlayer(1, 1, true, filter);
            specialAction.addTarget(target);
            if (specialAction.canActivate(source.getControllerId(), game).canActivate()) {
                game.getState().getSpecialActions().add(specialAction);
            }
        }
    }

    @Override
    public ManaOptions getManaOptions(Ability source, Game game, ManaCost unpaid) {
        ManaOptions options = new ManaOptions();
        if (unpaid.getMana().getGeneric() == 0) {
            return options;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.isComputer()) {
            return options;
        }
        int opponentCanPayMax = 0;
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            ManaOptions availableMana = opponent.getManaAvailable(game);
            for (Mana mana : availableMana) {
                if (mana.count() <= 0) continue;
                opponentCanPayMax = Math.max(opponentCanPayMax, mana.count());
            }
        }
        if (opponentCanPayMax > 0) {
            options.addMana(Mana.GenericMana(Math.min(unpaid.getMana().getGeneric(), opponentCanPayMax)));
        }
        return options;
    }

    static {
        filter.add(TargetController.NOT_YOU.getPlayerPredicate());
    }
}

