/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.AwakenEffect;
import mage.cards.Card;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledLandPermanent;
import mage.target.common.TargetControlledPermanent;
import mage.util.CardUtil;

public class AwakenAbility
extends SpellAbility {
    private final String rule;
    private static final FilterControlledLandPermanent filter = new FilterControlledLandPermanent("a land you control to awake");

    public AwakenAbility(Card card, int awakenValue, String awakenCosts) {
        super(card.getSpellAbility());
        this.newId();
        this.setCardName(card.getName() + " with awaken");
        this.zone = Zone.HAND;
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.clearManaCosts();
        this.clearManaCostsToPay();
        this.addCost(new ManaCostsImpl(awakenCosts));
        this.addTarget(new TargetControlledPermanent(filter));
        this.addEffect(new AwakenEffect(awakenValue));
        this.rule = "Awaken " + awakenValue + "&mdash;" + awakenCosts + " <i>(If you cast this spell for " + awakenCosts + ", also put " + CardUtil.getOneOneCountersText(awakenValue) + " on target land you control and it becomes a 0/0 Elemental creature with haste. It's still a land.)</i>";
    }

    protected AwakenAbility(AwakenAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public AwakenAbility copy() {
        return new AwakenAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

