/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.StaticAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.BackupEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.target.common.TargetCreaturePermanent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class BackupAbility
extends EntersBattlefieldTriggeredAbility {
    private final Card card;
    private final int amount;
    private final List<Ability> abilitiesToAdd = new ArrayList<Ability>();

    public BackupAbility(Card card, int amount) {
        super(null, false);
        this.addEffect(new BackupEffect(amount, this.abilitiesToAdd));
        this.card = card;
        this.amount = amount;
        this.addTarget(new TargetCreaturePermanent());
    }

    protected BackupAbility(BackupAbility ability) {
        super(ability);
        this.amount = ability.amount;
        this.card = ability.card;
        this.abilitiesToAdd.addAll(ability.abilitiesToAdd);
    }

    @Override
    public BackupAbility copy() {
        return new BackupAbility(this);
    }

    @Override
    public String getRule() {
        return "Backup " + this.amount + " <i>(When this creature enters the battlefield, put " + CardUtil.getOneOneCountersText(this.amount) + " on target creature. If that's another creature, it gains the following abilit" + (this.abilitiesToAdd.size() > 1 ? "ies" : "y") + " until end of turn.)</i>";
    }

    public void addAbility(Ability ability) {
        this.addAbility(ability, null);
    }

    public void addAbility(Ability ability, Watcher watcher) {
        this.addAbility(ability, watcher, false);
    }

    public void addAbility(Ability ability, boolean dontAddToCard) {
        this.addAbility(ability, null, dontAddToCard);
    }

    public void addAbility(Ability ability, Watcher watcher, boolean dontAddToCard) {
        Effect wrongEffect;
        if (ability instanceof StaticAbility && (wrongEffect = (Effect)ability.getEffects().stream().filter(effect -> effect instanceof ContinuousEffect).map(effect -> (ContinuousEffect)effect).filter(effect -> effect.getDuration().equals((Object)Duration.EndOfTurn)).findFirst().orElse(null)) != null) {
            throw new IllegalArgumentException("Wrong code usage. Backup ability and source card must contains static effects. Wrong effect: " + wrongEffect.getClass().getName());
        }
        if (watcher != null) {
            ability.addWatcher(watcher);
        }
        if (!dontAddToCard) {
            this.card.addAbility(ability);
        }
        this.abilitiesToAdd.add(ability);
        CardUtil.castStream(this.getEffects().stream(), BackupEffect.class).forEach(backupEffect -> backupEffect.addAbility(ability));
    }

    public boolean hasAbilities() {
        return !this.abilitiesToAdd.isEmpty();
    }
}

