/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.hint.common.BargainCostWasPaidHint;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.players.Player;

public class BargainAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final FilterControlledPermanent bargainFilter = new FilterControlledPermanent("an artifact, enchantment, or token");
    private static final String promptString = "Bargain? (To Bargain, sacrifice an artifact, enchantment, or token)";
    private static final String keywordText = "Bargain";
    private static final String reminderText = "You may sacrifice an artifact, enchantment, or token as you cast this spell.";
    private final String rule;
    public static final String BARGAIN_ACTIVATION_VALUE_KEY = "bargainActivation";
    protected OptionalAdditionalCost additionalCost;

    public static OptionalAdditionalCost makeBargainCost() {
        OptionalAdditionalCostImpl cost = new OptionalAdditionalCostImpl(keywordText, reminderText, new SacrificeTargetCost(bargainFilter));
        cost.setRepeatable(false);
        return cost;
    }

    public BargainAbility() {
        super(Zone.STACK, null);
        this.additionalCost = BargainAbility.makeBargainCost();
        this.rule = this.additionalCost.getName() + ' ' + this.additionalCost.getReminderText();
        this.setRuleAtTheTop(true);
        this.addHint(BargainCostWasPaidHint.instance);
    }

    private BargainAbility(BargainAbility ability) {
        super(ability);
        this.rule = ability.rule;
        this.additionalCost = ability.additionalCost.copy();
    }

    @Override
    public BargainAbility copy() {
        return new BargainAbility(this);
    }

    public void resetBargain() {
        if (this.additionalCost != null) {
            this.additionalCost.reset();
        }
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.resetBargain();
        boolean canPay = this.additionalCost.canPay(ability, this, ability.getControllerId(), game);
        if (!canPay || !player.chooseUse(Outcome.Sacrifice, promptString, ability, game)) {
            return;
        }
        this.additionalCost.activate();
        for (Cost cost : (Costs)((Object)this.additionalCost)) {
            ability.getCosts().add(cost.copy());
        }
        ability.setCostsTag(BARGAIN_ACTIVATION_VALUE_KEY, null);
    }

    @Override
    public String getCastMessageSuffix() {
        return this.additionalCost.getCastSuffixMessage(0);
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    static {
        bargainFilter.add(Predicates.or(CardType.ARTIFACT.getPredicate(), CardType.ENCHANTMENT.getPredicate(), TokenPredicate.TRUE));
    }
}

