/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.RenownAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class BecomesRenownedSourceEffect
extends OneShotEffect {
    BecomesRenownedSourceEffect(int renownValue) {
        super(Outcome.BoostCreature);
        this.staticText = this.setText(renownValue);
    }

    private BecomesRenownedSourceEffect(BecomesRenownedSourceEffect effect) {
        super(effect);
    }

    @Override
    public BecomesRenownedSourceEffect copy() {
        return new BecomesRenownedSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && source instanceof RenownAbility) {
            game.informPlayers(permanent.getLogName() + " is now renowned");
            int renownValue = ((RenownAbility)source).getRenownValue();
            if (renownValue == Integer.MAX_VALUE) {
                renownValue = CardUtil.getSourceCostsTag(game, source, "X", 0);
            }
            new AddCountersSourceEffect(CounterType.P1P1.createInstance(renownValue), true).apply(game, source);
            permanent.setRenowned(true);
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.BECOMES_RENOWNED, source.getSourceId(), source, source.getControllerId(), renownValue));
            return true;
        }
        return false;
    }

    private String setText(int renownValue) {
        StringBuilder sb = new StringBuilder("Renown ");
        sb.append(renownValue == Integer.MAX_VALUE ? "X" : Integer.valueOf(renownValue)).append(" <i>(When this creature deals combat damage to a player, if it isn't renowned, put ").append(renownValue == Integer.MAX_VALUE ? "X" : CardUtil.numberToText(renownValue, "a")).append(" +1/+1 counter on it and it becomes renowned.)</i>");
        return sb.toString();
    }
}

