/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.common.BlocksOrBlockedSourceTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.game.Game;

public class BushidoAbility
extends BlocksOrBlockedSourceTriggeredAbility {
    private final DynamicValue value;
    private final String rule;

    public BushidoAbility(int value) {
        this(StaticValue.get(value));
    }

    public BushidoAbility(DynamicValue value) {
        super(new BoostSourceEffect(value, value, Duration.EndOfTurn));
        this.value = value;
        this.rule = (value instanceof StaticValue ? "Bushido " + value.toString() : "{this} has bushido X, where X is " + value.getMessage()) + BushidoAbility.getReminder(value.toString());
    }

    static String getReminder(String xValue) {
        return "  <i>(Whenever this creature blocks or becomes blocked, it gets +" + xValue + "/+" + xValue + " until end of turn.)</i>";
    }

    protected BushidoAbility(BushidoAbility ability) {
        super(ability);
        this.value = ability.value;
        this.rule = ability.rule;
    }

    @Override
    public BushidoAbility copy() {
        return new BushidoAbility(this);
    }

    public int getValue(Ability source, Game game, Effect effect) {
        return this.value.calculate(game, source, effect);
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

