/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.BuybackEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class BuybackAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final String keywordText = "Buyback";
    private static final String reminderTextCost = "You may {cost} in addition to any other costs as you cast this spell. If you do, put this card into your hand as it resolves.";
    private static final String reminderTextMana = "You may pay an additional {cost} as you cast this spell. If you do, put this card into your hand as it resolves.";
    protected OptionalAdditionalCost buybackCost;
    private int amountToReduceBy = 0;

    public BuybackAbility(String manaString) {
        super(Zone.STACK, new BuybackEffect());
        this.addBuybackCostAndSetup(new OptionalAdditionalCostImpl(keywordText, reminderTextMana, new ManaCostsImpl(manaString)));
        this.setRuleAtTheTop(true);
    }

    public BuybackAbility(Cost cost) {
        super(Zone.STACK, new BuybackEffect());
        this.addBuybackCostAndSetup(new OptionalAdditionalCostImpl(keywordText, "&mdash;", reminderTextCost, cost));
        this.setRuleAtTheTop(true);
    }

    private void addBuybackCostAndSetup(OptionalAdditionalCost newCost) {
        this.buybackCost = newCost;
        this.buybackCost.setCostType(VariableCostType.ADDITIONAL);
    }

    protected BuybackAbility(BuybackAbility ability) {
        super(ability);
        this.buybackCost = ability.buybackCost.copy();
        this.amountToReduceBy = ability.amountToReduceBy;
    }

    @Override
    public BuybackAbility copy() {
        return new BuybackAbility(this);
    }

    @Override
    public void addCost(Cost cost) {
        ((OptionalAdditionalCostImpl)this.buybackCost).add(cost);
    }

    public void resetReduceCost() {
        this.amountToReduceBy = 0;
    }

    public int reduceCost(int genericManaToReduce) {
        int amountToReduce = genericManaToReduce;
        boolean foundCostToReduce = false;
        for (Object cost : (Costs)((Object)this.buybackCost)) {
            if (!(cost instanceof ManaCostsImpl)) continue;
            for (Object c : (ManaCostsImpl)cost) {
                if (!(c instanceof GenericManaCost)) continue;
                int newCostCMC = ((GenericManaCost)c).manaValue() - this.amountToReduceBy - genericManaToReduce;
                foundCostToReduce = true;
                if (newCostCMC > 0) {
                    this.amountToReduceBy += genericManaToReduce;
                    continue;
                }
                amountToReduce = ((GenericManaCost)c).manaValue() - this.amountToReduceBy;
                this.amountToReduceBy = ((GenericManaCost)c).manaValue();
            }
        }
        if (foundCostToReduce) {
            return amountToReduce;
        }
        return 0;
    }

    @Override
    public boolean isActivated() {
        return this.buybackCost.isActivated();
    }

    private void resetBuyback(Game game) {
        this.activateBuyback(game, false);
        this.resetReduceCost();
        this.buybackCost.reset();
    }

    private void activateBuyback(Game game, Boolean isActivated) {
        game.getState().setValue(this.getSourceId().toString() + "_activatedBuyback", isActivated);
        if (isActivated.booleanValue()) {
            this.buybackCost.activate();
        } else {
            this.buybackCost.reset();
        }
    }

    public boolean isBuybackActivated(Game game) {
        return Boolean.TRUE.equals(game.getState().getValue(this.getSourceId().toString() + "_activatedBuyback"));
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        Player player;
        if (ability instanceof SpellAbility && (player = game.getPlayer(ability.getControllerId())) != null) {
            this.resetBuyback(game);
            if (player.chooseUse(Outcome.AIDontUseIt, "Pay " + this.buybackCost.getText(false) + " ?", ability, game)) {
                this.activateBuyback(game, true);
                for (Cost cost : (Costs)((Object)this.buybackCost)) {
                    if (cost instanceof ManaCostsImpl) {
                        ability.addManaCostsToPay((ManaCostsImpl)cost.copy());
                        continue;
                    }
                    ability.addCost(cost.copy());
                }
            }
        }
    }

    @Override
    public String getRule() {
        return this.buybackCost.getText(false) + ' ' + this.buybackCost.getReminderText();
    }

    @Override
    public String getCastMessageSuffix() {
        return this.buybackCost.getCastSuffixMessage(0);
    }
}

