/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopySourceSpellEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetSacrifice;

public class CasualtyAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final String keywordText = "Casualty";
    private final String promptString;
    private final String rule;
    protected OptionalAdditionalCost additionalCost;

    private static TargetSacrifice makeFilter(int number) {
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature with power " + number + " or greater");
        filter.add(new PowerPredicate(ComparisonType.MORE_THAN, number - 1));
        return new TargetSacrifice(1, filter);
    }

    public CasualtyAbility(int number) {
        super(Zone.STACK, null);
        String reminderText = "As you cast this spell, you may sacrifice a creature with power " + number + " or greater. When you do, copy this spell.";
        this.additionalCost = new OptionalAdditionalCostImpl(keywordText, reminderText, new SacrificeTargetCost(CasualtyAbility.makeFilter(number)));
        this.additionalCost.setRepeatable(false);
        this.promptString = "Sacrifice a creature with power " + number + " or greater?";
        this.rule = this.additionalCost.getName() + ' ' + number + ' ' + this.additionalCost.getReminderText();
        this.setRuleAtTheTop(true);
    }

    private CasualtyAbility(CasualtyAbility ability) {
        super(ability);
        this.additionalCost = ability.additionalCost;
        this.promptString = ability.promptString;
        this.rule = ability.rule;
    }

    public void resetCasualty() {
        if (this.additionalCost != null) {
            this.additionalCost.reset();
        }
    }

    @Override
    public CasualtyAbility copy() {
        return new CasualtyAbility(this);
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.resetCasualty();
        boolean canPay = this.additionalCost.canPay(ability, this, ability.getControllerId(), game);
        if (!canPay || !player.chooseUse(Outcome.Sacrifice, this.promptString, ability, game)) {
            return;
        }
        this.additionalCost.activate();
        for (Cost cost : (Costs)((Object)this.additionalCost)) {
            ability.addCost(cost.copy());
        }
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new CopySourceSpellEffect(), false, "when you do, copy this spell"), ability);
    }

    @Override
    public String getCastMessageSuffix() {
        return this.additionalCost == null ? "" : this.additionalCost.getCastSuffixMessage(0);
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

