/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInGraveyardBattlefieldOrStack;
import mage.util.CardUtil;

class CraftCost
extends CostImpl {
    private final TargetCardInGraveyardBattlefieldOrStack target;

    CraftCost(TargetCardInGraveyardBattlefieldOrStack target) {
        this.target = target;
        target.withNotTarget(true);
    }

    private CraftCost(CraftCost cost) {
        super(cost);
        this.target = cost.target.copy();
    }

    @Override
    public CraftCost copy() {
        return new CraftCost(this);
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.target.canChooseOrAlreadyChosen(controllerId, source, game);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            this.paid = false;
            return this.paid;
        }
        player.chooseTarget(Outcome.Exile, this.target, source, game);
        Set<Card> cards = this.target.getTargets().stream().map(uuid -> {
            Permanent permanent = game.getPermanent((UUID)uuid);
            if (permanent != null) {
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.EXILED_WHILE_CRAFTING, permanent.getId(), source, player.getId()));
                return permanent;
            }
            return game.getCard((UUID)uuid);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        player.moveCardsToExile(cards, source, game, true, CardUtil.getExileZoneId(game, source), CardUtil.getSourceName(game, source));
        this.paid = true;
        return this.paid;
    }
}

