/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.continuous.AddCardTypeSourceEffect;
import mage.abilities.icon.CardIconImpl;
import mage.abilities.icon.CardIconType;
import mage.abilities.keyword.CrewCost;
import mage.abilities.keyword.CrewEventEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.util.CardUtil;

public class CrewAbility
extends SimpleActivatedAbility {
    private final int value;

    public CrewAbility(int value) {
        this(value, null);
    }

    public CrewAbility(int value, Cost altCost) {
        super(Zone.BATTLEFIELD, new AddCardTypeSourceEffect(Duration.EndOfTurn, CardType.ARTIFACT, CardType.CREATURE), new CrewCost(value, altCost));
        this.addEffect(new CrewEventEffect());
        this.addIcon(new CardIconImpl(CardIconType.ABILITY_CREW, "Crew " + value));
        this.value = value;
        if (altCost != null) {
            this.addSubAbility(new SimpleStaticAbility(Zone.ALL, new InfoEffect("you may " + CardUtil.addCostVerb(altCost.getText()) + " rather than pay {this}'s crew cost")));
        }
    }

    protected CrewAbility(CrewAbility ability) {
        super(ability);
        this.value = ability.value;
    }

    @Override
    public CrewAbility copy() {
        return new CrewAbility(this);
    }

    @Override
    public String getRule() {
        return "Crew " + this.value + (this.maxActivationsPerTurn == 1 ? ". Activate only once each turn." : "") + " <i>(Tap any number of creatures you control with total power " + this.value + " or more: This Vehicle becomes an artifact creature until end of turn.)</i>";
    }
}

