/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.awt.Color;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.CrewIncreasedPowerAbility;
import mage.abilities.common.CrewSaddleIncreasedPowerAbility;
import mage.abilities.common.CrewSaddleWithToughnessAbility;
import mage.abilities.common.CrewWithToughnessAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.hint.HintUtils;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class CrewCost
extends CostImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("another untapped creature you control");
    private final int value;
    private final Cost altCost;

    CrewCost(int value, Cost altCost) {
        this.value = value;
        this.altCost = altCost;
    }

    private CrewCost(CrewCost cost) {
        super(cost);
        this.value = cost.value;
        this.altCost = cost.altCost != null ? cost.altCost.copy() : null;
    }

    private boolean handleAltCost(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.altCost == null || !this.altCost.canPay(ability, source, controllerId, game)) {
            return false;
        }
        Player player = game.getPlayer(controllerId);
        String message = CardUtil.getTextWithFirstCharUpperCase(CardUtil.addCostVerb(this.altCost.getText())) + " rather than the crew cost?";
        return player != null && player.chooseUse(Outcome.Benefit, message, source, game) && this.altCost.pay(ability, game, source, controllerId, noMana, costToPay);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.handleAltCost(ability, game, source, controllerId, noMana, costToPay)) {
            this.paid = true;
            return true;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true){

            @Override
            public String getMessage(Game game) {
                int selectedPower = this.targets.keySet().stream().map(game::getPermanent).filter(Objects::nonNull).mapToInt(p -> CrewCost.getCrewPower(p, game)).sum();
                String extraInfo = "(selected power " + selectedPower + " of " + CrewCost.this.value + ")";
                if (selectedPower >= CrewCost.this.value) {
                    extraInfo = HintUtils.prepareText(extraInfo, Color.GREEN);
                }
                return super.getMessage(game) + " " + extraInfo;
            }
        };
        if (target.choose(Outcome.Tap, controllerId, source.getSourceId(), source, game)) {
            int sumPower = 0;
            for (UUID targetId : target.getTargets()) {
                Permanent permanent;
                GameEvent event = new GameEvent(GameEvent.EventType.CREW_VEHICLE, targetId, source, controllerId);
                if (game.replaceEvent(event) || (permanent = game.getPermanent(targetId)) == null || !permanent.tap(source, game)) continue;
                sumPower += CrewCost.getCrewPower(permanent, game);
            }
            boolean bl = this.paid = sumPower >= this.value;
            if (this.paid) {
                for (UUID targetId : target.getTargets()) {
                    game.fireEvent(GameEvent.getEvent(GameEvent.EventType.CREWED_VEHICLE, targetId, source, controllerId));
                }
            }
        } else {
            return false;
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        if (this.altCost != null && this.altCost.canPay(ability, source, controllerId, game)) {
            return true;
        }
        int sumPower = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(filter, controllerId, game)) {
            int powerToAdd = CrewCost.getCrewPower(permanent, game);
            if (powerToAdd > 0) {
                sumPower += powerToAdd;
            }
            if (sumPower < this.value) continue;
            return true;
        }
        return false;
    }

    @Override
    public CrewCost copy() {
        return new CrewCost(this);
    }

    private static int getCrewPower(Permanent permanent, Game game) {
        if (permanent.hasAbility(CrewWithToughnessAbility.getInstance(), game) || permanent.hasAbility(CrewSaddleWithToughnessAbility.getInstance(), game)) {
            return permanent.getToughness().getValue();
        }
        if (permanent.getAbilities(game).containsClass(CrewIncreasedPowerAbility.class) || permanent.getAbilities(game).containsClass(CrewSaddleIncreasedPowerAbility.class)) {
            return permanent.getPower().getValue() + 2;
        }
        return permanent.getPower().getValue();
    }

    static {
        filter.add(TappedPredicate.UNTAPPED);
        filter.add(AnotherPredicate.instance);
    }
}

