/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Set;
import java.util.UUID;
import mage.ApprovingObject;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.mana.ManaOptions;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

public class EmergeAbility
extends SpellAbility {
    private final ManaCosts<ManaCost> emergeCost;
    public static final String EMERGE_ACTIVATION_CREATURE_REFERENCE = "emergeActivationMOR";
    private final String emergeFromText;
    private final FilterPermanent filter;

    public EmergeAbility(Card card, String emergeManaString) {
        this(card, emergeManaString, StaticFilters.FILTER_PERMANENT_CREATURE, "");
    }

    public EmergeAbility(Card card, String emergeManaString, FilterPermanent filter, String emergeFromText) {
        super(card.getSpellAbility());
        this.filter = TargetSacrifice.makeFilter(filter);
        this.emergeFromText = emergeFromText;
        this.emergeCost = new ManaCostsImpl<ManaCost>(emergeManaString);
        this.newId();
        this.setCardName(card.getName() + " with emerge");
        this.zone = Zone.HAND;
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.clearManaCosts();
        this.clearManaCostsToPay();
        this.addCost(this.emergeCost.copy());
        this.setRuleAtTheTop(true);
    }

    private EmergeAbility(EmergeAbility ability) {
        super(ability);
        this.emergeCost = ability.emergeCost.copy();
        this.filter = ability.filter;
        this.emergeFromText = ability.emergeFromText;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Player controller;
        if (super.canActivate(playerId, game).canActivate() && (controller = game.getPlayer(this.getControllerId())) != null) {
            for (Permanent creature : game.getBattlefield().getActivePermanents(this.filter, this.getControllerId(), this, game)) {
                ManaCosts<ManaCost> costToPay = CardUtil.reduceCost((ManaCosts<ManaCost>)this.emergeCost.copy(), creature.getManaValue());
                if (!costToPay.canPay(this, this, this.getControllerId(), game)) continue;
                return new ActivatedAbility.ActivationStatus(new ApprovingObject(this, game));
            }
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    @Override
    public ManaOptions getMinimumCostToActivate(UUID playerId, Game game) {
        int maxCMC = 0;
        for (Permanent permanentToSacrifice : game.getBattlefield().getActivePermanents(this.filter, playerId, this, game)) {
            int cmc = permanentToSacrifice.getManaValue();
            if (cmc <= maxCMC) continue;
            maxCMC = cmc;
        }
        ManaOptions manaOptions = super.getMinimumCostToActivate(playerId, game);
        for (Mana mana : manaOptions) {
            if (mana.getGeneric() > maxCMC) {
                mana.setGeneric(mana.getGeneric() - maxCMC);
                continue;
            }
            mana.setGeneric(0);
        }
        return manaOptions;
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        Player controller = game.getPlayer(this.getControllerId());
        if (controller != null) {
            Permanent creature;
            TargetSacrifice target = new TargetSacrifice(this.filter);
            target.withChooseHint("to sacrifice for emerge");
            if (controller.choose(Outcome.Sacrifice, target, this, game) && (creature = game.getPermanent(target.getFirstTarget())) != null) {
                CardUtil.reduceCost((Ability)this, creature.getManaValue());
                boolean reducedToZero = this.getManaCostsToPay().isEmpty();
                if (super.activate(game, allowedIdentifiers, reducedToZero)) {
                    MageObjectReference mor = new MageObjectReference(creature, game);
                    if (creature.sacrifice(this, game)) {
                        this.setCostsTag(EMERGE_ACTIVATION_CREATURE_REFERENCE, mor);
                        return true;
                    }
                    this.activated = false;
                }
            }
        }
        return false;
    }

    @Override
    public EmergeAbility copy() {
        return new EmergeAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        String text = "Emerge ";
        if (!this.emergeFromText.isEmpty()) {
            text = text + this.emergeFromText + " ";
        }
        text = text + this.emergeCost.getText();
        if (this.emergeFromText.isEmpty()) {
            text = text + " <i>(You may cast this spell by sacrificing a creature and paying the emerge cost reduced by that creature's mana value.)</i>";
        }
        return text;
    }
}

