/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EncoreRequirementEffect
extends RequirementEffect {
    private final MageObjectReference token;
    private final UUID playerId;

    EncoreRequirementEffect(MageObjectReference token, UUID playerId) {
        super(Duration.EndOfTurn);
        this.token = token;
        this.playerId = playerId;
    }

    private EncoreRequirementEffect(EncoreRequirementEffect effect) {
        super(effect);
        this.token = effect.token;
        this.playerId = effect.playerId;
    }

    @Override
    public EncoreRequirementEffect copy() {
        return new EncoreRequirementEffect(this);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.token.refersTo(permanent, game);
    }

    @Override
    public UUID mustAttackDefender(Ability source, Game game) {
        return this.playerId;
    }

    @Override
    public boolean mustAttack(Game game) {
        return true;
    }

    @Override
    public boolean mustBlock(Game game) {
        return false;
    }
}

