/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EncoreSacrificeEffect
extends OneShotEffect {
    private final Set<MageObjectReference> mageObjectReferenceSet = new HashSet<MageObjectReference>();

    EncoreSacrificeEffect(Set<MageObjectReference> mageObjectReferenceSet) {
        super(Outcome.Benefit);
        this.mageObjectReferenceSet.addAll(mageObjectReferenceSet);
        this.staticText = "sacrifice those tokens";
    }

    private EncoreSacrificeEffect(EncoreSacrificeEffect effect) {
        super(effect);
        this.mageObjectReferenceSet.addAll(effect.mageObjectReferenceSet);
    }

    @Override
    public EncoreSacrificeEffect copy() {
        return new EncoreSacrificeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (MageObjectReference mageObjectReference : this.mageObjectReferenceSet) {
            Permanent permanent = mageObjectReference.getPermanent(game);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

