/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.ArrayList;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.AttachEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

public class EquipAbility
extends ActivatedAbilityImpl {
    private String costReduceText = null;
    private final boolean showAbilityHint;

    public EquipAbility(int cost) {
        this(cost, true);
    }

    public EquipAbility(int cost, boolean showAbilityHint) {
        this(Outcome.AddAbility, (Cost)new GenericManaCost(cost), showAbilityHint);
    }

    public EquipAbility(Outcome outcome, Cost cost) {
        this(outcome, cost, true);
    }

    public EquipAbility(Outcome outcome, Cost cost, boolean showAbilityHint) {
        this(outcome, cost, new TargetControlledCreaturePermanent(), showAbilityHint);
    }

    public EquipAbility(Outcome outcome, Cost cost, Target target) {
        this(outcome, cost, target, true);
    }

    public EquipAbility(Outcome outcome, Cost cost, Target target, boolean showAbilityHint) {
        super(Zone.BATTLEFIELD, new AttachEffect(outcome, "Equip"), cost);
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        Predicates.collectAllComponents(target.getFilter().getPredicates(), target.getFilter().getExtraPredicates(), list);
        if (list.stream().filter(p -> p instanceof TargetController.ControllerPredicate).map(p -> (TargetController.ControllerPredicate)p).noneMatch(p -> p.getController().equals((Object)TargetController.YOU))) {
            throw new IllegalArgumentException("Wrong code usage: equip ability must use target/filter with controller predicate - " + target);
        }
        this.addTarget(target);
        this.timing = TimingRule.SORCERY;
        this.showAbilityHint = showAbilityHint;
    }

    protected EquipAbility(EquipAbility ability) {
        super(ability);
        this.costReduceText = ability.costReduceText;
        this.showAbilityHint = ability.showAbilityHint;
    }

    public void setCostReduceText(String text) {
        this.costReduceText = text;
    }

    @Override
    public EquipAbility copy() {
        return new EquipAbility(this);
    }

    @Override
    public String getRule() {
        String costText;
        String targetText = this.getTargets().get(0) != null ? ((Target)this.getTargets().get(0)).getFilter().getMessage() : "creature";
        String reminderText = " <i>(" + this.getManaCosts().getText() + ": Attach to target " + targetText + ". Equip only as a sorcery.)</i>";
        StringBuilder sb = new StringBuilder(this.addRulePrefix("Equip"));
        if (!targetText.equals("creature you control")) {
            sb.append(' ').append(targetText);
        }
        if ((costText = this.getCosts().getText()) != null && !costText.isEmpty()) {
            sb.append("&mdash;").append(costText).append('.');
        } else {
            sb.append(' ');
        }
        sb.append(this.getManaCosts().getText());
        if (this.costReduceText != null && !this.costReduceText.isEmpty()) {
            sb.append(". ");
            sb.append(this.costReduceText);
        }
        if (this.maxActivationsPerTurn == 1) {
            sb.append(". Activate only once each turn.");
        }
        if (this.showAbilityHint) {
            sb.append(reminderText);
        }
        return sb.toString().replace("..", ".");
    }
}

