/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FadingEffect
extends OneShotEffect {
    FadingEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "remove a fade counter from {this}. If you can't, sacrifice it";
    }

    FadingEffect(FadingEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            int amount = permanent.getCounters(game).getCount(CounterType.FADE);
            if (amount > 0) {
                permanent.removeCounters(CounterType.FADE.createInstance(), source, game);
            } else {
                permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }

    @Override
    public FadingEffect copy() {
        return new FadingEffect(this);
    }
}

