/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collections;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.keyword.FirebendingAbilityEffect;

public class FirebendingAbility
extends AttacksTriggeredAbility {
    private final DynamicValue amount;

    public FirebendingAbility(int amount) {
        this(StaticValue.get(amount));
    }

    public FirebendingAbility(DynamicValue amount) {
        super(new FirebendingAbilityEffect(amount));
        this.amount = amount;
    }

    private FirebendingAbility(FirebendingAbility ability) {
        super(ability);
        this.amount = ability.amount;
    }

    @Override
    public FirebendingAbility copy() {
        return new FirebendingAbility(this);
    }

    @Override
    public String getRule() {
        if (this.amount instanceof StaticValue) {
            return "firebending " + this.amount + " <i>(Whenever this creature attacks, add " + String.join((CharSequence)"", Collections.nCopies(((StaticValue)this.amount).getValue(), "{R}")) + ". This mana lasts until end of combat.)</i>";
        }
        return "firebending X, where X is " + this.amount.getMessage() + ". <i>(Whenever this creature attacks, add X {R}. This mana lasts until end of combat.)</i>";
    }
}

