/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.costs.AlternativeSourceCostsImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.FreerunningCondition;
import mage.abilities.keyword.FreerunningWatcher;
import mage.game.Game;

public class FreerunningAbility
extends AlternativeSourceCostsImpl {
    private static final String FREERUNNING_KEYWORD = "Freerunning";
    private static final String FREERUNNING_REMINDER = "You may cast this spell for its freerunning cost if you dealt combat damage to a player this turn with an Assassin or commander";

    public FreerunningAbility(String manaString) {
        this(new ManaCostsImpl(manaString));
    }

    public FreerunningAbility(Cost cost) {
        super(FREERUNNING_KEYWORD, FREERUNNING_REMINDER, cost);
        this.setRuleAtTheTop(true);
        this.addWatcher(new FreerunningWatcher());
        this.addHint(FreerunningCondition.getHint());
    }

    private FreerunningAbility(FreerunningAbility ability) {
        super(ability);
    }

    @Override
    public FreerunningAbility copy() {
        return new FreerunningAbility(this);
    }

    @Override
    public boolean isAvailable(Ability source, Game game) {
        return FreerunningCondition.instance.apply(game, source);
    }

    public static String getActivationKey() {
        return FreerunningAbility.getActivationKey(FREERUNNING_KEYWORD);
    }
}

