/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObject;
import mage.abilities.common.ZoneChangeTriggeredAbility;
import mage.abilities.keyword.HauntEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCreaturePermanent;

class HauntExileAbility
extends ZoneChangeTriggeredAbility {
    private static final String RULE_TEXT_CREATURE = "Haunt <i>(When this creature dies, exile it haunting target creature.)</i>";
    private static final String RULE_TEXT_SPELL = "Haunt <i>(When this spell card is put into a graveyard after resolving, exile it haunting target creature.)</i>";
    private boolean creatureHaunt;

    public HauntExileAbility(boolean creatureHaunt) {
        super(creatureHaunt ? Zone.BATTLEFIELD : Zone.STACK, Zone.GRAVEYARD, new HauntEffect(), null, false);
        this.creatureHaunt = creatureHaunt;
        this.setRuleAtTheTop(creatureHaunt);
        this.addTarget(new TargetCreaturePermanent());
    }

    private HauntExileAbility(HauntExileAbility ability) {
        super(ability);
        this.creatureHaunt = ability.creatureHaunt;
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        boolean fromOK = true;
        Permanent sourcePermanent = (Permanent)game.getLastKnownInformation(this.sourceId, Zone.BATTLEFIELD);
        if (this.creatureHaunt && sourcePermanent == null) {
            fromOK = false;
        }
        if (!this.hasSourceObjectAbility(game, sourcePermanent, event)) {
            return false;
        }
        Zone after = game.getState().getZone(this.sourceId);
        return fromOK && after != null && Zone.GRAVEYARD.match(after);
    }

    @Override
    public String getRule() {
        return this.creatureHaunt ? RULE_TEXT_CREATURE : RULE_TEXT_SPELL;
    }

    @Override
    public HauntExileAbility copy() {
        return new HauntExileAbility(this);
    }
}

