/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.icon.CardIcon;
import mage.abilities.icon.CardIconImpl;
import mage.abilities.icon.CardIconType;
import mage.abilities.keyword.HexproofFromBlackAbility;
import mage.abilities.keyword.HexproofFromBlueAbility;
import mage.abilities.keyword.HexproofFromGreenAbility;
import mage.abilities.keyword.HexproofFromRedAbility;
import mage.abilities.keyword.HexproofFromWhiteAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.util.CardUtil;

public abstract class HexproofBaseAbility
extends SimpleStaticAbility
implements MageSingleton {
    protected HexproofBaseAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    public abstract boolean checkObject(MageObject var1, Ability var2, Game var3);

    public static Set<HexproofBaseAbility> getFromColor(ObjectColor color) {
        HashSet<HexproofBaseAbility> abilities = new HashSet<HexproofBaseAbility>();
        if (color.isWhite()) {
            abilities.add(HexproofFromWhiteAbility.getInstance());
        }
        if (color.isBlue()) {
            abilities.add(HexproofFromBlueAbility.getInstance());
        }
        if (color.isBlack()) {
            abilities.add(HexproofFromBlackAbility.getInstance());
        }
        if (color.isRed()) {
            abilities.add(HexproofFromRedAbility.getInstance());
        }
        if (color.isGreen()) {
            abilities.add(HexproofFromGreenAbility.getInstance());
        }
        return abilities;
    }

    public static HexproofBaseAbility getFirstFromColor(ObjectColor color) {
        if (color.isWhite()) {
            return HexproofFromWhiteAbility.getInstance();
        }
        if (color.isBlue()) {
            return HexproofFromBlueAbility.getInstance();
        }
        if (color.isBlack()) {
            return HexproofFromBlackAbility.getInstance();
        }
        if (color.isRed()) {
            return HexproofFromRedAbility.getInstance();
        }
        if (color.isGreen()) {
            return HexproofFromGreenAbility.getInstance();
        }
        return null;
    }

    public abstract String getCardIconHint(Game var1);

    @Override
    public List<CardIcon> getIcons(Game game) {
        if (game == null) {
            return Collections.singletonList(CardIconImpl.ABILITY_HEXPROOF);
        }
        return Collections.singletonList(new CardIconImpl(CardIconType.ABILITY_HEXPROOF, CardUtil.getTextWithFirstCharUpperCase(this.getCardIconHint(game))));
    }
}

