/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.keyword.HideawayExileEffect;
import mage.abilities.keyword.HideawayWatcher;
import mage.cards.Card;
import mage.util.CardUtil;

public class HideawayAbility
extends EntersBattlefieldTriggeredAbility {
    private final int amount;
    private final String etbObjectDescription;

    public HideawayAbility(Card card, int amount) {
        super(new HideawayExileEffect(amount));
        this.amount = amount;
        this.addWatcher(new HideawayWatcher());
        this.etbObjectDescription = EntersBattlefieldTriggeredAbility.getThisObjectDescription(card);
    }

    private HideawayAbility(HideawayAbility ability) {
        super(ability);
        this.amount = ability.amount;
        this.etbObjectDescription = ability.etbObjectDescription;
    }

    @Override
    public String getRule() {
        return "Hideaway " + this.amount + " <i>(When " + this.etbObjectDescription + " enters, look at the top " + CardUtil.numberToText(this.amount) + " cards of your library, exile one face down, then put the rest on the bottom of your library in a random order.)</i>";
    }

    @Override
    public HideawayAbility copy() {
        return new HideawayAbility(this);
    }
}

