/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.MadnessCardExiledEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class MadnessReplacementEffect
extends ReplacementEffectImpl {
    public MadnessReplacementEffect(ManaCosts<ManaCost> madnessCost, int lifeCost) {
        super(Duration.EndOfGame, Outcome.Benefit);
        String costText = lifeCost > 0 ? "Madness\u2014" + madnessCost.getText() + ", Pay " + lifeCost + " life." : "Madness " + madnessCost.getText();
        this.staticText = costText + " <i>(If you discard this card, you may cast it for its madness cost instead of putting it into your graveyard.)</i>";
    }

    private MadnessReplacementEffect(MadnessReplacementEffect effect) {
        super(effect);
    }

    @Override
    public MadnessReplacementEffect copy() {
        return new MadnessReplacementEffect(this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        if (card == null) {
            return false;
        }
        if (!controller.moveCards(card, Zone.EXILED, source, game)) {
            return false;
        }
        game.processAction();
        MadnessCardExiledEvent gameEvent = new MadnessCardExiledEvent(card.getId(), source, controller.getId());
        game.fireEvent(gameEvent);
        return true;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId()) && ((ZoneChangeEvent)event).getFromZone() == Zone.HAND && ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD;
    }
}

