/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class MeleeWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> playersAttacked = new HashMap<UUID, Set<UUID>>(0);

    public MeleeWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case BEGIN_COMBAT_STEP_PRE: {
                this.playersAttacked.clear();
                return;
            }
            case ATTACKER_DECLARED: {
                if (!game.getOpponents(event.getPlayerId()).contains(event.getTargetId())) {
                    return;
                }
                this.playersAttacked.computeIfAbsent(event.getPlayerId(), x -> new HashSet()).add(event.getTargetId());
            }
        }
    }

    static int getNumberOfAttackedPlayers(UUID attackerId, Game game) {
        return game.getState().getWatcher(MeleeWatcher.class).playersAttacked.getOrDefault(attackerId, Collections.emptySet()).size();
    }
}

