/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.keyword.MobilizeEffect;
import mage.util.CardUtil;

public class MobilizeAbility
extends AttacksTriggeredAbility {
    public MobilizeAbility(int count) {
        this(StaticValue.get(count));
    }

    public MobilizeAbility(DynamicValue count) {
        super(new MobilizeEffect(count), false, MobilizeAbility.makeText(count));
    }

    protected MobilizeAbility(MobilizeAbility ability) {
        super(ability);
    }

    @Override
    public MobilizeAbility copy() {
        return new MobilizeAbility(this);
    }

    private static String makeText(DynamicValue amount) {
        boolean plural;
        String numToText;
        String message;
        if (amount instanceof StaticValue) {
            int count = ((StaticValue)amount).getValue();
            message = "" + count;
            numToText = CardUtil.numberToText(count, "a");
            plural = count > 1;
        } else {
            message = "X, where X is " + amount.getMessage() + '.';
            numToText = "X";
            plural = true;
        }
        return "Mobilize " + message + " <i>(Whenever this creature attacks, create " + numToText + " tapped and attacking 1/1 red Warrior creature token" + (plural ? "s" : "") + ". Sacrifice " + (plural ? "them" : "it") + " at the beginning of the next end step.)</i>";
    }
}

