/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.StaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.EntersBattlefieldEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.util.CardUtil;

class ModularStaticAbility
extends StaticAbility {
    private final String ruleText;

    ModularStaticAbility(int amount) {
        super(Zone.ALL, new EntersBattlefieldEffect((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(amount))));
        this.ruleText = "This enters the battlefield with " + CardUtil.getOneOneCountersText(amount) + " on it.";
        this.setRuleVisible(false);
    }

    private ModularStaticAbility(ModularStaticAbility ability) {
        super(ability);
        this.ruleText = ability.ruleText;
    }

    @Override
    public ModularStaticAbility copy() {
        return new ModularStaticAbility(this);
    }

    @Override
    public String getRule() {
        return this.ruleText;
    }
}

